/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.system;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.SplashScreen;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.dialogs.CertificateTrustDialog;
import de.willuhn.jameica.gui.dialogs.HttpAuthDialog;
import de.willuhn.jameica.gui.dialogs.NewPasswordDialog;
import de.willuhn.jameica.gui.dialogs.PasswordDialog;
import de.willuhn.jameica.gui.dialogs.SimpleDialog;
import de.willuhn.jameica.gui.dialogs.TextDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.FormTextPart;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.messaging.CheckTrustMessage;
import de.willuhn.jameica.security.JameicaAuthenticator;
import de.willuhn.jameica.security.Login;
import de.willuhn.jameica.security.LoginVerifier;
import de.willuhn.jameica.system.AbstractApplicationCallback;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ApplicationCallbackSWT
extends AbstractApplicationCallback {
    private SplashScreen startupMonitor = null;
    private SplashScreen shutdownMonitor = null;
    private String username = null;
    private String password = null;

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String createPassword() throws Exception {
        this.password = Application.getStartupParams().getPassword();
        if (this.password != null && this.password.length() > 0) {
            Logger.info((String)"master password given via commandline");
            return this.password;
        }
        this.password = Application.getStartupParams().getPasswordUsingCommand();
        if (this.password != null && this.password.length() > 0) {
            Logger.debug((String)"master password given via command specified in commandline");
            return this.password;
        }
        NewPWD p = new NewPWD(1);
        String text = Application.getI18n().tr("Sie starten die Anwendung zum ersten Mal.\n\nBitte vergeben Sie ein Master-Passwort zum Schutz Ihrer pers\u00f6nlichen Daten. Es wird anschlie\u00dfend bei jedem Start des Programms ben\u00f6tigt.");
        text = Customizing.SETTINGS.getString("application.firststart.text", text);
        p.setText(text);
        p.setUsernameText(Customizing.SETTINGS.getString("application.firststart.username", null));
        p.setTitle(Application.getI18n().tr("Master-Passwort"));
        p.setMonitor(0);
        try {
            this.password = (String)p.open();
            this.username = p.getUsername();
        }
        catch (OperationCanceledException e) {
            throw new OperationCanceledException(Application.getI18n().tr("Passwort-Eingabe abgebrochen"), e);
        }
        return this.password;
    }

    @Override
    public String getPassword() throws Exception {
        return this.getPassword(null);
    }

    @Override
    public String getPassword(LoginVerifier verifier) throws Exception {
        if (this.username == null) {
            this.username = Application.getStartupParams().getUsername();
        }
        if (this.password != null) {
            return this.password;
        }
        this.password = Application.getStartupParams().getPassword();
        if (this.password == null || this.password.length() == 0) {
            this.password = Application.getStartupParams().getPasswordUsingCommand();
        }
        if (this.password != null && this.password.length() > 0) {
            Logger.info((String)"master password given via commandline");
            if (verifier == null) {
                return this.password;
            }
            if (verifier.verify(this.username, this.password.toCharArray())) {
                return this.password;
            }
            Logger.info((String)"commandline password wrong, asking user");
        }
        PWD dialog = new PWD(verifier);
        this.password = (String)dialog.open();
        this.username = dialog.getUsername();
        return this.password;
    }

    @Override
    public void changePassword() throws Exception {
        NewPasswordDialog p = new NewPasswordDialog(1);
        String text = Application.getI18n().tr("Bitte geben Sie Ihr neues Master-Passwort zum Schutz Ihrer pers\u00f6nlichen Daten ein.\nEs wird anschlie\u00dfend bei jedem Start von Jameica ben\u00f6tigt.");
        text = Customizing.SETTINGS.getString("application.changepassword.text", text);
        p.setText(text);
        p.setTitle(Application.getI18n().tr("Neues Master-Passwort"));
        this.password = (String)p.open();
    }

    @Override
    public ProgressMonitor getStartupMonitor() {
        if (this.startupMonitor != null) {
            return this.startupMonitor;
        }
        this.startupMonitor = new SplashScreen(SplashScreen.Mode.Startup, false);
        this.startupMonitor.setStatusText(" starting...");
        this.startupMonitor.init();
        return this.startupMonitor;
    }

    @Override
    public ProgressMonitor getShutdownMonitor() {
        if (this.shutdownMonitor != null) {
            return this.shutdownMonitor;
        }
        this.shutdownMonitor = new SplashScreen(SplashScreen.Mode.Shutdown, true);
        this.shutdownMonitor.init();
        return this.shutdownMonitor;
    }

    @Override
    public void startupError(String errorMessage, Throwable t) {
        Display d = Display.getCurrent();
        if (d == null) {
            d = new Display();
        }
        final Shell s = new Shell(d);
        s.setSize(500, 400);
        s.setLayout((Layout)new GridLayout());
        s.setText(Application.getI18n().tr("Fataler Fehler beim Start von Jameica."));
        Label l = new Label((Composite)s, 0);
        l.setForeground(d.getSystemColor(3));
        l.setLayoutData((Object)new GridData(768));
        l.setText(errorMessage);
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        t.printStackTrace(pw);
        pw.flush();
        Text trace = new Text((Composite)s, 2050);
        trace.setEditable(false);
        trace.setBackground(d.getSystemColor(1));
        trace.setText(w.toString());
        trace.setLayoutData((Object)new GridData(1808));
        Button b = new Button((Composite)s, 2048);
        b.setLayoutData((Object)new GridData(128));
        b.setText("    OK    ");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                s.close();
            }
        });
        s.open();
        while (!s.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
        try {
            s.dispose();
            d.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String askUser(String question, String labeltext) throws Exception {
        TextDialog d = new TextDialog(1);
        d.setText(question);
        d.setTitle(labeltext);
        d.setLabelText(labeltext);
        return (String)d.open();
    }

    @Override
    public String askPassword(String question) throws Exception {
        PasswordDialog d = new PasswordDialog(1){

            @Override
            protected boolean checkPassword(String password) {
                return true;
            }
        };
        d.setText(question);
        return (String)d.open();
    }

    @Override
    public boolean askUser(String question) throws Exception {
        return this.askUser(question, (String[])null);
    }

    @Override
    public boolean askUser(String question, String[] variables) throws Exception {
        return this.askUser(question, variables, true);
    }

    @Override
    public boolean askUser(String question, boolean storeAnswer) throws Exception {
        return this.askUser(question, null, storeAnswer);
    }

    @Override
    public boolean askUser(String question, String[] variables, boolean storeAnswer) throws Exception {
        return this.askUser(null, question, variables, storeAnswer);
    }

    private boolean askUser(final Shell shell, final String question, String[] variables, final boolean storeAnswer) throws Exception {
        String s;
        if (question == null) {
            Logger.warn((String)"<null> question!");
            return false;
        }
        if (storeAnswer && (s = this.settings.getString(question, null)) != null) {
            return s.equalsIgnoreCase("true");
        }
        final String text = variables == null || variables.length == 0 ? question : MessageFormat.format(question, variables);
        AbstractDialog d = new AbstractDialog(1){
            private Boolean choice;
            private CheckboxInput check;
            {
                super(position);
                this.choice = Boolean.FALSE;
                this.check = new CheckboxInput(false);
            }

            protected Object getData() throws Exception {
                return this.choice;
            }

            @Override
            protected Shell createShell(Shell parent, int flags) {
                return super.createShell(shell != null ? shell : parent, flags);
            }

            @Override
            protected void paint(Composite parent) throws Exception {
                SimpleContainer g = new SimpleContainer(parent, true);
                if (text.startsWith("<form>")) {
                    g.addPart(new FormTextPart(text));
                } else {
                    g.addText(text, true);
                }
                if (storeAnswer) {
                    g.addCheckbox(this.check, Application.getI18n().tr("Diese Frage k\u00fcnftig nicht mehr anzeigen"));
                }
                ButtonArea buttons = new ButtonArea();
                buttons.addButton("   " + this.i18n.tr("Ja") + "   ", new Action(){

                    @Override
                    public void handleAction(Object context) throws ApplicationException {
                        if (storeAnswer && ((Boolean)check.getValue()).booleanValue()) {
                            ApplicationCallbackSWT.this.settings.setAttribute(question, true);
                        }
                        choice = Boolean.TRUE;
                        this.close();
                    }
                }, null, false, "ok.png");
                buttons.addButton("   " + this.i18n.tr("Nein") + "   ", new Action(){

                    @Override
                    public void handleAction(Object context) throws ApplicationException {
                        if (storeAnswer && ((Boolean)check.getValue()).booleanValue()) {
                            ApplicationCallbackSWT.this.settings.setAttribute(question, false);
                        }
                        choice = Boolean.FALSE;
                        this.close();
                    }
                }, null, false, "process-stop.png");
                g.addButtonArea(buttons);
                Point p = this.getShell().computeSize(450, -1);
                this.setSize(p.x, p.y);
            }
        };
        d.setTitle(Application.getI18n().tr("Frage"));
        try {
            return (Boolean)d.open();
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
            return false;
        }
        catch (Exception e) {
            Logger.error((String)"error while asking user", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean lockExists(String lockfile) {
        try {
            Shell shell = this.startupMonitor != null ? this.startupMonitor.getShell() : null;
            return this.askUser(shell, Application.getI18n().tr("Jameica scheint bereits zu laufen. Wollen Sie den Startvorgang wirklich fortsetzen?"), null, true);
        }
        catch (Exception e) {
            Logger.error((String)"error while asking user", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean checkTrust(X509Certificate cert) throws Exception {
        CheckTrustMessage msg = new CheckTrustMessage(cert);
        Application.getMessagingFactory().sendSyncMessage(msg);
        Exception ex = msg.getException();
        if (ex != null) {
            throw ex;
        }
        Boolean trust = msg.isTrusted();
        if (trust != null) {
            Logger.info((String)("cert: " + cert.getSubjectDN().getName() + "," + (trust != false ? "" : " NOT ") + " trusted by: " + msg.getTrustedBy()));
            return trust;
        }
        CertificateTrustDialog d = new CertificateTrustDialog(1, cert);
        Boolean b = (Boolean)d.open();
        return b;
    }

    @Override
    public void notifyUser(String text) throws Exception {
        if (text == null) {
            Logger.warn((String)"no text to be displayed for user notification");
            return;
        }
        SimpleDialog d = new SimpleDialog(1);
        d.setTitle(Application.getI18n().tr("Information"));
        d.setText(text);
        d.open();
    }

    @Override
    public Login login(JameicaAuthenticator auth) throws Exception {
        Login l = super.login(auth);
        if (l != null) {
            return l;
        }
        HttpAuthDialog d = new HttpAuthDialog(1, auth);
        return (Login)d.open();
    }

    private class NewPWD
    extends NewPasswordDialog {
        public NewPWD(int position) {
            super(position);
        }

        @Override
        protected Shell createShell(Shell parent, int flags) {
            Shell p = null;
            if (ApplicationCallbackSWT.this.startupMonitor != null) {
                p = ApplicationCallbackSWT.this.startupMonitor.getShell();
            }
            return super.createShell(p != null ? p : parent, flags);
        }
    }

    private class PWD
    extends PasswordDialog {
        private LoginVerifier verifier;

        public PWD(LoginVerifier verifier) {
            super(1);
            this.verifier = null;
            this.verifier = verifier;
            this.setText(Application.getI18n().tr("Bitte geben Sie das Master-Passwort ein."));
            this.setUsernameText(Customizing.SETTINGS.getString("application.start.username", null));
            this.setTitle(Application.getI18n().tr("Master-Passwort"));
            this.setMonitor(0);
        }

        @Override
        protected Shell createShell(Shell parent, int flags) {
            Shell p = null;
            if (ApplicationCallbackSWT.this.startupMonitor != null) {
                p = ApplicationCallbackSWT.this.startupMonitor.getShell();
            }
            return super.createShell(p != null ? p : parent, flags);
        }

        @Override
        protected boolean checkPassword(String password) {
            if (password == null || password.length() == 0) {
                this.setErrorText(Application.getI18n().tr("Bitte geben Sie Ihr Master-Passwort ein.") + " " + this.getRetryString());
                return false;
            }
            if (this.verifier == null) {
                return true;
            }
            boolean b = this.verifier.verify(this.getUsername(), password.toCharArray());
            if (!b) {
                Logger.warn((String)("master password wrong, remaining retries: " + this.getRemainingRetries()));
                this.setErrorText(Application.getI18n().tr("Passwort falsch.") + " " + this.getRetryString());
            }
            return b && super.checkPassword(password);
        }

        private String getRetryString() {
            String retries = this.getRemainingRetries() > 1 ? Application.getI18n().tr("Versuche") : Application.getI18n().tr("Versuch");
            return Application.getI18n().tr("Noch") + " " + this.getRemainingRetries() + " " + retries + ".";
        }
    }
}

